<?php
require './portal/config.php';

function sendTelegram($message) {
    global $api, $chatid;
    
    $url = "https://api.telegram.org/bot{$api}/sendMessage";
    $data = [
        'chat_id' => $chatid,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    
    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context = stream_context_create($options);
    return file_get_contents($url, false, $context);
}

function getIpInfo($ip) {
    $response = @file_get_contents("http://ipinfo.io/{$ip}/json");
    return $response ? json_decode($response) : false;
}
?>